/*	Copyright 2002 by Eric Postpischil, http://edp.org.
	See license information in index.html.
*/


#include	"StdAfx.h"


/*	Display the message of the last Windows error.  A title string is
	passed in, which should contain the application name and some
	description of the situation in which the error was encountered,
	such as opening a file or creating a window.
*/
void	DisplayWindowsError(const char *title)
{
	LPVOID	lpMsgBuf;
	int		value;


	if (FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		0,
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	))
	{
		MessageBeep(MB_ICONSTOP);
		value = MessageBox(NULL, (LPCTSTR) lpMsgBuf, title,
			MB_OK | MB_ICONSTOP);
		LocalFree(lpMsgBuf);
	}
	/*	If the format failed, display a message about that.  Message boxes
		with these flags ought to be displayed even when memory is low.
	*/
	else
	{
		MessageBeep(MB_ICONHAND);
		value = MessageBox(NULL, "Unable to format error message.", title,
			MB_OK | MB_SYSTEMMODAL | MB_ICONHAND);
	}

	/* If the message display failed, try a last resort. */
	if (value == 0)
		MessageBox(NULL, "Unable to display error message box.", "TriSolve",
			MB_OK | MB_SYSTEMMODAL | MB_ICONHAND);
}


/*	Display the message of the last C library error.  A title string is
	passed in, which should contain the application name and some
	description of the situation in which the error was encountered,
	such as opening a file.
*/
void	DisplayCError(const char *title)
{
	MessageBeep(MB_ICONSTOP);
	if (0 == MessageBox(NULL, _sys_errlist[errno], title,
			MB_OK | MB_ICONSTOP))
		// If the message display failed, try a last resort.
		MessageBox(NULL, "Unable to display error message box.", "TriSolve",
			MB_OK | MB_SYSTEMMODAL | MB_ICONHAND);
}


/*	Display an application error message.  A title string is also
	passed in, which should contain the application name and some
	description of the situation in which the error was encountered,
	such as opening a file or creating a window.
*/
void	DisplayError(const char *title, const char *message)
{
	MessageBeep(MB_ICONSTOP);
	if (0 == MessageBox(NULL, message, title, MB_OK | MB_ICONSTOP))
		// If the message display failed, try a last resort.
		MessageBox(NULL, "Unable to display error message box.", "TriSolve",
			MB_OK | MB_SYSTEMMODAL | MB_ICONHAND);
}